;----------------------------------------------------------------------------
; Sega Dreamcast
; NullDC r104
; by BBB
; 1.0
;----------------------------------------------------------------------------

;Settings
autoStart = 1
noConsole = 1
autoHideMenu = 1
fullScreen = 1
showVMU = 0
loadDefaultImage = 1
patchRegion = 1
configPath = %emuPath%nullDC.cfg

;Write Settings
IniWrite, %autoStart%, %configPath%, nullDC, Emulator.AutoStart
IniWrite, %noConsole%, %configPath%, nullDC, Emulator.NoConsole
IniWrite, %autoHideMenu%, %configPath%, nullDC_GUI, AutoHideMenu
IniWrite, %fullScreen%, %configPath%, nullDC_GUI, Fullscreen
IniWrite, %showVMU%, %configPath%, drkMaple, VMU.Show
IniWrite, %loadDefaultImage%, %configPath%, ImageReader, LoadDefaultImage
IniWrite, %patchRegion%, %configPath%, ImageReader, PatchRegion
IniWrite, %romPath%%romname%%RomExtension%, %configPath%, ImageReader, DefaultImage

;Fixes hangin previous nullDC on bad exits or loads
Process, Exist, %executable%
if !ErrorLevel = 0
Process, Close, %executable%

Run, %executable%, %emuPath%, hide
;Enough to hide the startup logo
Sleep, 2000

;Let's completely hide the menu by slighly moving the window off screen
;nullDC will self adjust once the menu autohides
if(fullScreen = 1){
  yOffset = -20
  winHeight := A_ScreenHeight - yOffset
  WinMove, nullDC,, 0, %yOffset%, %A_ScreenWidth%, %winHeight%
}

WinShow, nullDC

Process, WaitClose, %executable%     

ExitApp
           
CloseProcess:
  Process, Close, %executable%
return